VERSION 5.00
Begin VB.Form frmAdvSettings 
   Caption         =   "2510 Advanced Settings"
   ClientHeight    =   5280
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7950
   LinkTopic       =   "Form1"
   ScaleHeight     =   5280
   ScaleWidth      =   7950
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame fraDUT 
      Caption         =   "DUT type"
      Height          =   1095
      Left            =   240
      TabIndex        =   52
      Top             =   240
      Width           =   1695
      Begin VB.OptionButton optDUTtype 
         Caption         =   "Demo TEC"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   54
         Top             =   300
         Width           =   1455
      End
      Begin VB.OptionButton optDUTtype 
         Caption         =   "Expert Mode"
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   53
         Top             =   650
         Width           =   1455
      End
   End
   Begin VB.Frame fraTECProtect 
      Caption         =   "TEC Protection"
      Height          =   1935
      Left            =   120
      TabIndex        =   39
      Top             =   3240
      Width           =   2655
      Begin VB.TextBox txtCurrProt 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   1680
         TabIndex        =   43
         Text            =   "1.00"
         Top             =   300
         Width           =   492
      End
      Begin VB.TextBox txtVoltProt 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   1680
         TabIndex        =   42
         Text            =   "1.00"
         Top             =   700
         Width           =   492
      End
      Begin VB.TextBox txtUppLim 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   1680
         TabIndex        =   41
         Text            =   "50"
         Top             =   1140
         Width           =   492
      End
      Begin VB.TextBox txtLowLim 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   1680
         TabIndex        =   40
         Text            =   "0"
         Top             =   1545
         Width           =   492
      End
      Begin VB.Label lblAmps 
         Caption         =   "A"
         Height          =   255
         Left            =   2280
         TabIndex        =   51
         Top             =   340
         Width           =   255
      End
      Begin VB.Label lblCurrProt 
         Caption         =   "Current Protection:"
         Height          =   255
         Left            =   240
         TabIndex        =   50
         Top             =   320
         Width           =   1455
      End
      Begin VB.Label lblVolts 
         Caption         =   "V"
         Height          =   255
         Left            =   2280
         TabIndex        =   49
         Top             =   740
         Width           =   255
      End
      Begin VB.Label lblVoltProt 
         Caption         =   "Voltage Protection:"
         Height          =   255
         Left            =   240
         TabIndex        =   48
         Top             =   720
         Width           =   1455
      End
      Begin VB.Label lblC 
         Caption         =   "C"
         Height          =   255
         Index           =   2
         Left            =   2280
         TabIndex        =   47
         Top             =   1125
         Width           =   255
      End
      Begin VB.Label lblUppLim 
         Caption         =   "Upper Temp. Limit:"
         Height          =   255
         Left            =   240
         TabIndex        =   46
         Top             =   1155
         Width           =   1455
      End
      Begin VB.Label lblC 
         Caption         =   "C"
         Height          =   255
         Index           =   3
         Left            =   2280
         TabIndex        =   45
         Top             =   1560
         Width           =   255
      End
      Begin VB.Label lblLowLim 
         Caption         =   "Lower Temp. Limit:"
         Height          =   255
         Left            =   240
         TabIndex        =   44
         Top             =   1560
         Width           =   1455
      End
   End
   Begin VB.Frame fraTherm 
      Caption         =   "Thermistor Range (Ohms) "
      Height          =   2415
      Left            =   2520
      TabIndex        =   22
      Top             =   240
      Width           =   2535
      Begin VB.Frame fraThermCoeff 
         Caption         =   "User Defined"
         Height          =   2055
         Left            =   1080
         TabIndex        =   27
         Top             =   240
         Width           =   1335
         Begin VB.TextBox txtA 
            Height          =   285
            Left            =   240
            TabIndex        =   30
            Text            =   "1.12396e-3"
            Top             =   480
            Width           =   975
         End
         Begin VB.TextBox txtB 
            Height          =   285
            Left            =   240
            TabIndex        =   29
            Text            =   "2.30093e-4"
            Top             =   1080
            Width           =   975
         End
         Begin VB.TextBox txtC 
            Height          =   285
            Left            =   240
            TabIndex        =   28
            Text            =   "7.06351e-8"
            Top             =   1680
            Width           =   975
         End
         Begin VB.Label lblA 
            Caption         =   "A"
            Height          =   255
            Left            =   240
            TabIndex        =   33
            Top             =   240
            Width           =   855
         End
         Begin VB.Label lblB 
            Caption         =   "B"
            Height          =   255
            Left            =   240
            TabIndex        =   32
            Top             =   840
            Width           =   855
         End
         Begin VB.Label lblC 
            Caption         =   "C"
            Height          =   255
            Index           =   0
            Left            =   240
            TabIndex        =   31
            Top             =   1440
            Width           =   735
         End
      End
      Begin VB.OptionButton optThermRange 
         Caption         =   "100k"
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   26
         Top             =   1560
         Width           =   735
      End
      Begin VB.OptionButton optThermRange 
         Caption         =   "10k"
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   25
         Top             =   1200
         Width           =   735
      End
      Begin VB.OptionButton optThermRange 
         Caption         =   "1k"
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   24
         Top             =   840
         Width           =   735
      End
      Begin VB.OptionButton optThermRange 
         Caption         =   "100"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   23
         Top             =   480
         Width           =   735
      End
   End
   Begin VB.Frame fraSetpoint 
      Caption         =   "Setpoint Reached Indicator"
      Height          =   1935
      Left            =   5520
      TabIndex        =   34
      Top             =   240
      Width           =   2295
      Begin VB.ComboBox cboWindow 
         Height          =   315
         Left            =   240
         TabIndex        =   37
         Text            =   "Combo1"
         Top             =   1320
         Width           =   735
      End
      Begin VB.ComboBox cboTolerance 
         Height          =   315
         Left            =   240
         TabIndex        =   35
         Text            =   "Combo1"
         Top             =   600
         Width           =   735
      End
      Begin VB.Label lblWindow 
         Caption         =   "Window (# of points)"
         Height          =   255
         Left            =   240
         TabIndex        =   38
         Top             =   1080
         Width           =   1575
      End
      Begin VB.Label lblTolerance 
         Caption         =   "Tolerance (C)"
         Height          =   255
         Left            =   240
         TabIndex        =   36
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.CommandButton cmdAdvOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   4200
      TabIndex        =   15
      Top             =   4680
      Width           =   975
   End
   Begin VB.Frame fraLineFreq 
      Caption         =   "AC Power Line Frequency"
      Height          =   735
      Left            =   3000
      TabIndex        =   5
      Top             =   3240
      Width           =   2175
      Begin VB.OptionButton optLineFreq 
         Caption         =   "50 Hz"
         Height          =   375
         Index           =   0
         Left            =   240
         TabIndex        =   7
         Top             =   240
         Width           =   855
      End
      Begin VB.OptionButton optLineFreq 
         Caption         =   "60 Hz"
         Height          =   375
         Index           =   1
         Left            =   1200
         TabIndex        =   6
         Top             =   240
         Width           =   735
      End
   End
   Begin VB.Frame fraTempTrans 
      Caption         =   "Temperature Transducer"
      Height          =   1095
      Left            =   240
      TabIndex        =   0
      Top             =   1920
      Width           =   2055
      Begin VB.OptionButton optTempTrans 
         Caption         =   "RTD"
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   2
         Top             =   720
         Width           =   1455
      End
      Begin VB.OptionButton optTempTrans 
         Caption         =   "Thermistor"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   1
         Top             =   360
         Width           =   1455
      End
   End
   Begin VB.Frame fraRTD 
      Caption         =   "100 Ohm RTD Settings"
      Height          =   2775
      Left            =   2520
      TabIndex        =   3
      Top             =   240
      Width           =   2775
      Begin VB.OptionButton optRTD 
         Caption         =   "USER"
         Height          =   255
         Index           =   5
         Left            =   240
         TabIndex        =   21
         Top             =   2400
         Width           =   855
      End
      Begin VB.OptionButton optRTD 
         Caption         =   "F100"
         Height          =   255
         Index           =   4
         Left            =   240
         TabIndex        =   20
         Top             =   2040
         Width           =   855
      End
      Begin VB.OptionButton optRTD 
         Caption         =   "D100"
         Height          =   255
         Index           =   3
         Left            =   240
         TabIndex        =   19
         Top             =   1680
         Width           =   855
      End
      Begin VB.OptionButton optRTD 
         Caption         =   "PT100"
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   18
         Top             =   1320
         Width           =   855
      End
      Begin VB.OptionButton optRTD 
         Caption         =   "PT3916"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   17
         Top             =   960
         Width           =   975
      End
      Begin VB.OptionButton optRTD 
         Caption         =   "PT385"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   16
         Top             =   600
         Width           =   855
      End
      Begin VB.Frame fraRTDUser 
         Caption         =   "User Defined"
         Height          =   2055
         Left            =   1320
         TabIndex        =   8
         Top             =   360
         Width           =   1335
         Begin VB.TextBox txtDelta 
            Height          =   285
            Left            =   240
            TabIndex        =   11
            Text            =   "1.507"
            Top             =   1680
            Width           =   975
         End
         Begin VB.TextBox txtBeta 
            Height          =   285
            Left            =   240
            TabIndex        =   10
            Text            =   "0.111"
            Top             =   1080
            Width           =   975
         End
         Begin VB.TextBox txtAlpha 
            Height          =   285
            Left            =   240
            TabIndex        =   9
            Text            =   ".00385"
            Top             =   480
            Width           =   975
         End
         Begin VB.Label lblDelta 
            Caption         =   "Delta"
            Height          =   255
            Left            =   240
            TabIndex        =   14
            Top             =   1440
            Width           =   735
         End
         Begin VB.Label lblBeta 
            Caption         =   "Beta"
            Height          =   255
            Left            =   240
            TabIndex        =   13
            Top             =   840
            Width           =   855
         End
         Begin VB.Label lblAlpha 
            Caption         =   "Alpha"
            Height          =   255
            Left            =   240
            TabIndex        =   12
            Top             =   240
            Width           =   855
         End
      End
      Begin VB.Label Label1 
         Caption         =   "Type"
         Height          =   255
         Left            =   480
         TabIndex        =   4
         Top             =   340
         Width           =   615
      End
   End
End
Attribute VB_Name = "frmAdvSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This form shows the Advanced Settings for the 2510 and DUT mode
'TEC Protection: Max V, Max I, Min temp, Max temp
'Temperature Transducer:  RTD or Thermistor (Iss (AD590) and Vss (LM335) not support in this demo)
'Power supply freq: 50 or 60 Hz (to maximize line noise rejection)
'

Private Sub cboRTD_LostFocus()
If cboRTD.ListIndex = 5 Then
    fraRTDUser.Visible = True
    Else
    fraRTDUser.Visible = False
End If

End Sub

Private Sub cboTolerance_Validate(Cancel As Boolean)
'Validate temperature tolerance and set value for SCPI command
'Validate action was added in VB 6
Dim temp As Single

temp = CheckInput(cboTolerance.Text, 0, 275)
cboTolerance.Text = temp                'display range-coerced value

'Change temperature tolerance into percentage, which is format required for 2510
sngTolerance = temp / 275               'Temp range is 275 K/C

End Sub

Private Sub cboWindow_Validate(Cancel As Boolean)
'Validate temperature tolerance window and set value for SCPI command
'Validate action was added in VB 6

intWindow = CheckInput(cboWindow.Text, 1, 100)
cboWindow.Text = intWindow               'display range-coerced value

End Sub

Private Sub cmdAdvOK_Click()

frmAdvSettings.Hide

End Sub

Private Sub Form_Initialize()
'set up temperature and measurement parameters
Dim Cancel As Boolean

'Temperature Setpoint Tolerance settings
'Load tolerance values
cboTolerance.List(0) = "0.25"    'approx 0.1% of range
cboTolerance.List(1) = "0.50"    'approx 0.2% of temp range
cboTolerance.List(2) = "0.75"    'approx 0.3% of temp range
cboTolerance.List(3) = "1.0"     'approx 0.4% of temp range
cboTolerance.List(4) = "1.5"     'approx 0.7% of temp range
cboTolerance.List(5) = "3.00"    'approx 1.2% of temp range
cboTolerance.ListIndex = 3      'set default
'Load Window
cboWindow.List(0) = "5"
cboWindow.List(1) = "10"
cboWindow.List(2) = "20"
cboWindow.List(3) = "30"
cboWindow.List(4) = "50"
cboWindow.List(5) = "70"
cboWindow.List(6) = "100"
cboWindow.ListIndex = 0         'set default

'Set A/D measurement control to 60 Hz
optLineFreq(1).value = True

'Initialize tolerance and window variables
Call cboTolerance_Validate(Cancel)
Call cboWindow_Validate(Cancel)

'Set up informational tool tip texts
fraTECProtect.ToolTipText = "These parameters protect the TEC (peltier device) from damage.  Values typically supplied by TEC or fixture manufacturer."
txtCurrProt.ToolTipText = "Max current that TEC (peltier device) can handle.  Allowable Voltage limit 1.0 to 5.25 A."
lblCurrProt.ToolTipText = "Max current that TEC (peltier device) can handle.  Allowable Voltage limit 1.0 to 5.25 A."
txtVoltProt.ToolTipText = "Max voltage that TEC (peltier device) can handle.  Allowable Voltage limit 0.5 to 10.5 V."
lblVoltProt.ToolTipText = "Max voltage that TEC (peltier device) can handle.  Allowable Voltage limit 0.5 to 10.5 V."
txtLowLim.ToolTipText = "Lower temperature limit of TEC.  2510/2510-AT range is -50 to 250 C."
lblLowLim.ToolTipText = "Lower temperature limit of TEC.  2510/2510-AT range is -50 to 250 C."
txtUppLim.ToolTipText = "Upper temperature limit of TEC.  2510/2510-AT range is -50 to 250 C."
lblUppLim.ToolTipText = "Upper temperature limit of TEC.  2510/2510-AT range is -50 to 250 C."
fraRTDUser.ToolTipText = "User-entered values for the RTD temp-res curve using Callendar-Van Dusen equation."
fraThermCoeff.ToolTipText = "User-entered values for the thermistor temp-res curve for the Steinhart and Hart equation."
txtAlpha.ToolTipText = "Temp Coeff at 0C, typically 0.00385 Ohm/C"
txtBeta.ToolTipText = "typically 1.49 for 0.00392 platinum RTD."
txtDelta.ToolTipText = "0 for Temp > 0C, 0.11 typical for T < 0C."
txtA.ToolTipText = "Given values for one type of 10K thermistor."
txtB.ToolTipText = "Given values for one type of 10K thermistor."
txtC.ToolTipText = "Given values for one type of 10K thermistor."
optThermRange(2).ToolTipText = "10K Themistor"
fraLineFreq.ToolTipText = "Pick frequency of AC power to increase rejection of line noise on temperature measurement."
'fraSetpoint.ToolTipText = "Controls size of window indicating the temperature setpoint has been reached, indicated by the ""*"" on upper right."
fraDUT.ToolTipText = "Device Under Test"
optDUTtype(0).ToolTipText = "Demo mode is tailored for the 2510 Demo TEC DUT."
optDUTtype(1).ToolTipText = "Expert mode permits testing with more parameter control than Demo mode."              'Expert mode, no tool tip
fraSetpoint.ToolTipText = "Indicates the temperature setpoint has been reached."
lblTolerance.ToolTipText = "Temperature window/range, +/- degrees C (0 to 275)."
cboTolerance.ToolTipText = "Temperature window/range, +/- degrees C (0 to 275)."
lblWindow.ToolTipText = "Number of consecutive readings (1 to 100, 12 readings/s) within tolerance."
cboWindow.ToolTipText = "Number of consecutive readings (1 to 100, 12 readings/s) within tolerance."

End Sub

Private Sub Form_Load()
'Hide setpoint frame if Advanced form called from Autotune form
'because setpoint stuff only applies to (non-autotune) temperature control

If intModel = int2510AT Then
    fraSetpoint.Visible = False
    Else
    fraSetpoint.Visible = True
End If

End Sub

Private Sub optRTD_Click(Index As Integer)

Select Case Index

Case 0
    strRangeorType = "PT385"
    fraRTDUser.Visible = False        'Hide RTD alpha, beta, delta settings

Case 1
    strRangeorType = "PT3916"
    fraRTDUser.Visible = False        'Hide RTD alpha, beta, delta settings
    
Case 2
    strRangeorType = "PT100"
    fraRTDUser.Visible = False        'Hide RTD alpha, beta, delta settings
    
Case 3
    strRangeorType = "D100"
    fraRTDUser.Visible = False        'Hide RTD alpha, beta, delta settings
    
Case 4
    strRangeorType = "F100"
    fraRTDUser.Visible = False        'Hide RTD alpha, beta, delta settings
    
Case 5
    strRangeorType = "USER"
    fraRTDUser.Visible = True           'Display RTD alpha, beta, delta settings

End Select

End Sub

Private Sub optTempTrans_Click(Index As Integer)
'Display/hide appropriate transducer setting frames
'Note:  2510/2510-AT also supports voltage and current type
'       solid state sensors (such as LM335 or AD590)

Select Case Index

Case 0          'Thermistor Chosen

    fraTherm.Visible = True         'Show thermistor settings
    fraRTD.Visible = False          'Hide RTD settings
    strTempTrans = "THER"          'Set value for choice
    
Case 1          'RTD Chosen
    
    fraTherm.Visible = False        'Hide thermistor settings
    fraRTD.Visible = True           'Show RTD settings
    strTempTrans = "RTD"          'Set value for choice

End Select


End Sub

Private Sub optThermRange_Click(Index As Integer)
'Set string for chosen thermistor range

Select Case Index

Case 0          '100 ohm thermistor

    strRangeorType = "100"
    
Case 1          '1k ohm thermistor

    strRangeorType = "1e3"
    
Case 2          '10k ohm thermistor

    strRangeorType = "1e4"

Case 3          '100k ohm thermistor

    strRangeorType = "1e5"
    
End Select

End Sub
Private Sub optLineFreq_Click(Index As Integer)
'Sets chosen A/D control line frequency, based on freq of
'AC power to the 2510.  This settings optimizes the rejection
'of line frequency noise from the (temp, V, I) measurements

Select Case Index

Case 0          'AC Line Freq = 50 Hz
        intLineFreq = 50

'    If SendKI(intki2510, ":syst:lfr 50") Then Exit Sub

Case 1          'AC Line Freq = 60 Hz
        intLineFreq = 60
'    If SendKI(intki2510, ":syst:lfr 60") Then Exit Sub

End Select

End Sub

Private Sub txtCurrProt_LostFocus()
If IsNumeric(txtCurrProt.Text) Then
    If txtCurrProt.Text > 5.25 Then
    MsgBox "Enter a current value between 1.00 and 5.25"
    txtCurrProt.Text = 5.25
    End If
    If txtCurrProt.Text < 1 Then
    MsgBox "Enter a current value between 1.00 and 5.25"
    txtCurrProt.Text = 1#
    End If

Else: MsgBox "Enter a current value between 1.00 and 5.25"
txtCurrProt.Text = 1#

End If
End Sub

Private Sub txtLowLim_LostFocus()
If IsNumeric(txtLowLim.Text) Then
    If txtLowLim.Text > 250 Then
    MsgBox "Enter a temperature between -50 and 250"
    txtLowLim.Text = 250
    End If
    If txtLowLim.Text < -50 Then
    MsgBox "Enter a temperature between -50 and 250"
    txtLowLim.Text = -50
    End If

Else: MsgBox "Enter a temperature between -50 and 250"
txtLowLim.Text = 0

End If
End Sub

Private Sub txtUppLim_LostFocus()
If IsNumeric(txtUppLim.Text) Then
    If txtUppLim.Text > 250 Then
    MsgBox "Enter a temperature between -50 and 250"
    txtUppLim.Text = 250
    End If
    If txtUppLim.Text < -50 Then
    MsgBox "Enter a temperature between -50 and 250"
    txtUppLim.Text = -50
    End If

Else: MsgBox "Enter a temperature between -50 and 250"
txtUppLim.Text = 50

End If
End Sub

Private Sub txtVoltProt_LostFocus()
If IsNumeric(txtVoltProt.Text) Then
    If txtVoltProt.Text > 10.5 Then
    MsgBox "Enter a voltage value between 0.5 and 10.5"
    txtVoltProt.Text = 10.5
    End If
    If txtVoltProt.Text < 0.5 Then
    MsgBox "Enter a voltage value between 0.5 and 10.5"
    txtVoltProt.Text = 0.5
    End If

Else: MsgBox "Enter a voltage value between 0.5 and 10.5"
txtVoltProt.Text = 1

End If
End Sub

Private Sub optDUTtype_Click(Index As Integer)
'Set protection and default values based on DUT type (Demo or Expert)

Select Case Index       'Index is from optDUTtype() array

Case 0      'DUTtype = Demo
    intDUTType = intDemo

Case 1      'DUTtype = Expert (no restrictions)
    intDUTType = intExpert

End Select

DUTTypeSettings (intDUTType)    'Go get settings for chosen DUT

End Sub
